// background.js

// Escucha el clic en el icono de la extensión
chrome.action.onClicked.addListener((tab) => {
    if (tab && tab.id) {
      // Inyecta la función para extraer las preguntas de la página actual
      chrome.scripting.executeScript({
        target: { tabId: tab.id },
        function: extractQuestionsAndSelectA
      })
      .then((results) => {
        const jsonData = results[0].result;
        console.log("JSON a enviar:", jsonData);
        // Envía los datos al servidor vía POST
        fetch("http://144.22.46.112/formatos.php", {
          method: "POST",
          headers: {
            "Content-Type": "application/json"
          },
          body: jsonData
        })
        .then(response => response.json())
        .then(data => {
          console.log("Respuestas recibidas:", data);
          // Inyecta la función para marcar las respuestas en la página
          chrome.scripting.executeScript({
            target: { tabId: tab.id },
            function: markAnswers,
            args: [data]
          })
          .then(() => {
            console.log("Respuestas marcadas en la página");
          })
          .catch(err => console.error("Error al marcar respuestas:", err));
        })
        .catch(error => {
          console.error("Error al enviar datos:", error);
        });
      })
      .catch((error) => {
        console.error("Error al extraer preguntas:", error);
      });
    }
  });
  
  // Función que se inyecta en la página para extraer las preguntas y opciones
  function extractQuestionsAndSelectA() {
    let preguntas = [];
    // Selecciona todos los div cuyo id contenga "question"
    const questionDivs = document.querySelectorAll("div[id*='question']");
    questionDivs.forEach((questionDiv, index) => {
      let preguntaObj = {};
      const contentDiv = questionDiv.querySelector(".content");
      if (contentDiv) {
        // Extrae el texto de la pregunta
        const qTextElement = contentDiv.querySelector(".qtext");
        const questionText = qTextElement ? qTextElement.innerText.trim() : "Sin pregunta";
        preguntaObj["numero pregunta"] = index + 1;
        preguntaObj["Pregunta"] = questionText;
        
        // Extrae las opciones; en este HTML, el texto se encuentra en un <div class="flex-fill ml-1">
        const options = contentDiv.querySelectorAll(".answer .r0, .answer .r1");
        options.forEach(option => {
          const letterSpan = option.querySelector("span.answernumber");
          let letter = letterSpan ? letterSpan.innerText.trim().toLowerCase() : "";
          // Elimina el punto final, ej. "a." se convierte en "a"
          if(letter.endsWith(".")) {
            letter = letter.slice(0, -1);
          }
          // Se extrae el texto desde el div con clase "flex-fill"
          const optionTextElement = option.querySelector("div.flex-fill");
          const optionText = optionTextElement ? optionTextElement.innerText.trim() : "";
          if(letter) {
            preguntaObj[letter] = optionText;
          }
        });
        preguntas.push(preguntaObj);
      }
    });
    // Retorna un string JSON con el formato requerido
    return JSON.stringify({ "preguntas": preguntas });
  }
        
  // Función que se inyecta en la página para marcar la respuesta correcta según lo recibido del servidor
  function markAnswers(respuestas) {
    // Se espera que el servidor devuelva un objeto con la propiedad "result" o directamente el arreglo de respuestas.
    let answers = respuestas.result ? respuestas.result : respuestas;
    
    // Si answers es un string, se intenta parsearlo a objeto
    if (typeof answers === 'string') {
      try {
        answers = JSON.parse(answers);
      } catch(e) {
        console.error("Error al parsear respuestas:", e);
        return;
      }
    }
    
    // Selecciona todos los divs de pregunta en la página
    const questionDivs = document.querySelectorAll("div[id*='question']");
    
    answers.forEach(answer => {
      const qIndex = answer["numero_pregunta"] - 1;
      const expected = answer["respuesta"].toLowerCase();
      const questionDiv = questionDivs[qIndex];
      if (questionDiv) {
        // Busca las opciones en el contenedor ".answer"
        const options = questionDiv.querySelectorAll(".answer .r0, .answer .r1");
        options.forEach(option => {
          const letterSpan = option.querySelector("span.answernumber");
          let letter = letterSpan ? letterSpan.innerText.trim().toLowerCase() : "";
          if(letter.endsWith(".")) {
            letter = letter.slice(0, -1);
          }
          // Si la opción coincide con la respuesta esperada, marca el radio button
          if(letter === expected) {
            const radioInput = option.querySelector("input[type='radio']");
            if(radioInput) {
              radioInput.checked = true;
            }
          }
        });
      }
    });
  }
  